/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.gui;

import dev.lambdaurora.lambdynlights.accessor.DynamicLightHandlerHolder;
import dev.lambdaurora.lambdynlights.config.LightSourceSettingEntry;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SprucePositioned;
import dev.lambdaurora.spruceui.SpruceTextAlignment;
import dev.lambdaurora.spruceui.SpruceTexts;
import dev.lambdaurora.spruceui.background.Background;
import dev.lambdaurora.spruceui.background.EmptyBackground;
import dev.lambdaurora.spruceui.background.SimpleColorBackground;
import dev.lambdaurora.spruceui.navigation.NavigationEvent;
import dev.lambdaurora.spruceui.navigation.NavigationUtils;
import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import dev.lambdaurora.spruceui.widget.SpruceLabelWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.WithBackground;
import dev.lambdaurora.spruceui.widget.container.SpruceEntryListWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceParentWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceTextFieldWidget;
import dev.yumi.commons.TriState;
import dev.yumi.commons.collections.YumiCollections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7923;
import net.minecraft.class_8027;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightSourceListWidget
extends SpruceEntryListWidget<LightSourceListEntry> {
    private static final Background HIGHLIGHT_BACKGROUND = new SimpleColorBackground(128, 128, 128, 24);
    private final LightSourceListEntry explanationEntry;
    private final List<LightSourceEntry> entries = new ArrayList<LightSourceEntry>();
    private int lastIndex = 0;

    public LightSourceListWidget(Position position, int width, int height, SpruceTextFieldWidget searchBar) {
        super(position, width, height, 4, LightSourceListEntry.class);
        this.explanationEntry = new LightSourceListEntry(this);
        this.explanationEntry.children.add((SpruceWidget)new SpruceLabelWidget(Position.of((SprucePositioned)this.explanationEntry, (int)(this.explanationEntry.getWidth() / 2 - 145), (int)0), (class_2561)class_2561.method_43470((String)"\u2139 ").method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43469((String)"lambdynlights.menu.tabs.dynamic_lights.entity.explanation", (Object[])new Object[]{class_2561.method_43471((String)"lambdynlights")}).method_27692(class_124.field_1080)), 290, class_2477.method_10517().method_29428() ? SpruceTextAlignment.RIGHT : SpruceTextAlignment.LEFT));
        searchBar.setChangedListener(this::update);
        searchBar.setRenderTextProvider((input, firstCharacterIndex) -> {
            if (this.children().isEmpty()) {
                return class_5481.method_30747((String)input, (class_2583)class_2583.field_24360.method_10977(class_124.field_1061));
            }
            List<class_5481> list = Stream.of(input.split(" ")).map(this::stylizeFilterPart).map(class_2561::method_30937).toList();
            return class_5481.method_30755(list);
        });
    }

    private void update(@Nullable String filter) {
        if (filter == null) {
            this.replaceEntries(YumiCollections.concat(List.of(this.explanationEntry), this.entries, (List[])new List[0]));
        } else {
            List<String> entryFilter = List.of(filter.toLowerCase().split("\\s"));
            this.replaceEntries(YumiCollections.concat(List.of(this.explanationEntry), this.entries.stream().filter(entry -> this.checkFilter((LightSourceEntry)((Object)entry), entryFilter)).toList(), (List[])new List[0]));
        }
        for (int i = 0; i < this.children().size(); ++i) {
            LightSourceListEntry entry2 = (LightSourceListEntry)((Object)this.children().get(i));
            if (i % 2 != 0) {
                entry2.setBackground(HIGHLIGHT_BACKGROUND);
                continue;
            }
            entry2.setBackground((Background)EmptyBackground.EMPTY_BACKGROUND);
        }
    }

    private TriState evaluateValueFilter(String filter) {
        if (filter.isBlank()) {
            return TriState.DEFAULT;
        }
        if (filter.equalsIgnoreCase(SpruceTexts.OPTIONS_ON.getString())) {
            return TriState.TRUE;
        }
        if (filter.equalsIgnoreCase(SpruceTexts.OPTIONS_OFF.getString())) {
            return TriState.FALSE;
        }
        return switch (filter) {
            case "true", "1", "on" -> TriState.TRUE;
            case "false", "0", "off" -> TriState.FALSE;
            default -> TriState.DEFAULT;
        };
    }

    private boolean checkFilter(LightSourceEntry entry, @NotNull List<String> filter) {
        String name = entry.option.lambdynlights$getName().getString().toLowerCase();
        for (String part : filter) {
            TriState valueFilter;
            if (!(part.startsWith("@") ? !entry.option.lambdynlights$getId().method_12836().startsWith(part.substring(1)) : (part.startsWith("$") ? (valueFilter = this.evaluateValueFilter(part.substring(1))) != TriState.DEFAULT && entry.option.lambdynlights$getSetting().get() != valueFilter.toBoolean() : !name.contains(part)))) continue;
            return false;
        }
        return true;
    }

    private class_2561 stylizeFilterPart(String filter) {
        if (filter.startsWith("@")) {
            return class_2561.method_43470((String)(filter + " ")).method_27692(class_124.field_1075);
        }
        if (filter.startsWith("$")) {
            TriState valueFilter = this.evaluateValueFilter(filter.substring(1));
            class_5250 class_52502 = class_2561.method_43470((String)(filter + " "));
            return class_52502.method_27692(switch (valueFilter) {
                case TriState.TRUE, TriState.FALSE -> class_124.field_1065;
                default -> class_124.field_1061;
            });
        }
        return class_2561.method_43470((String)(filter + " "));
    }

    private void addEntry(DynamicLightHandlerHolder<?> holder) {
        if (holder.lambdynlights$getSetting() != null) {
            LightSourceEntry entry = LightSourceEntry.create(this, holder);
            this.entries.add(entry);
        }
    }

    public void addAll(List<DynamicLightHandlerHolder<?>> types) {
        types.stream().sorted(Comparator.comparing(handler -> handler.lambdynlights$getName().getString())).forEach(this::addEntry);
        this.update(null);
    }

    public void method_37020(class_6382 builder) {
        this.children().stream().filter(AbstractSpruceWidget::isMouseHovered).findFirst().ifPresentOrElse(hoveredEntry -> {
            hoveredEntry.method_37020(builder.method_37031());
            this.appendPositionNarrations(builder, (SpruceEntryListWidget.Entry)hoveredEntry);
        }, () -> {
            LightSourceListEntry focusedEntry = (LightSourceListEntry)this.getFocused();
            if (focusedEntry != null) {
                focusedEntry.method_37020(builder.method_37031());
                this.appendPositionNarrations(builder, focusedEntry);
            }
        });
        builder.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.component_list.usage"));
    }

    public static sealed class LightSourceListEntry
    extends SpruceEntryListWidget.Entry
    implements SpruceParentWidget<SpruceWidget>,
    WithBackground
    permits LightSourceEntry {
        protected final List<SpruceWidget> children = new ArrayList<SpruceWidget>();
        protected final LightSourceListWidget parent;
        @Nullable
        protected SpruceWidget focused;
        protected boolean dragging;
        protected Background background = EmptyBackground.EMPTY_BACKGROUND;

        protected LightSourceListEntry(LightSourceListWidget parent) {
            this.parent = parent;
        }

        public int getWidth() {
            return this.parent.getWidth() - this.parent.getBorder().getThickness() * 2;
        }

        public int getHeight() {
            return this.children.stream().mapToInt(SpruceWidget::getHeight).reduce(Integer::max).orElse(0) + 4;
        }

        public List<SpruceWidget> children() {
            return this.children;
        }

        @Nullable
        public SpruceWidget getFocused() {
            return this.focused;
        }

        public void setFocused(@Nullable SpruceWidget focused) {
            if (this.focused == focused) {
                return;
            }
            if (this.focused != null) {
                this.focused.method_25365(false);
            }
            this.focused = focused;
        }

        public void method_25365(boolean focused) {
            super.method_25365(focused);
            if (!focused) {
                this.setFocused(null);
            }
        }

        public Background getBackground() {
            return this.background;
        }

        public void setBackground(Background background) {
            this.background = background;
        }

        protected boolean onMouseClick(@NotNull class_11909 event, boolean doubleClick) {
            SpruceWidget element;
            Iterator it = this.iterator();
            do {
                if (it.hasNext()) continue;
                return false;
            } while (!(element = (SpruceWidget)it.next()).method_25402(event, doubleClick));
            this.setFocused(element);
            if (event.method_74245() == 0) {
                this.dragging = true;
            }
            return true;
        }

        protected boolean onMouseRelease(@NotNull class_11909 event) {
            this.dragging = false;
            return this.hoveredElement(event.comp_4798(), event.comp_4799()).filter(element -> element.method_25406(event)).isPresent();
        }

        protected boolean onMouseDrag(@NotNull class_11909 event, double deltaX, double deltaY) {
            return this.getFocused() != null && this.dragging && event.method_74245() == 0 && this.getFocused().method_25403(event, deltaX, deltaY);
        }

        protected boolean onKeyPress(@NotNull class_11908 event) {
            return this.focused != null && this.focused.method_25404(event);
        }

        protected boolean onKeyRelease(@NotNull class_11908 event) {
            return this.focused != null && this.focused.method_16803(event);
        }

        protected boolean onCharTyped(@NotNull class_11905 event) {
            return this.focused != null && this.focused.method_25400(event);
        }

        protected void renderWidget(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.forEach(widget -> widget.render(graphics, mouseX, mouseY, delta));
        }

        protected void renderBackground(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.background.render(graphics, (SpruceWidget)this, 0, mouseX, mouseY, delta);
        }

        public void method_37020(class_6382 builder) {
            SpruceWidget focused = this.getFocused();
            if (focused != null) {
                focused.method_37020(builder);
            }
        }

        public boolean onNavigation(@NotNull NavigationEvent event) {
            if (this.requiresCursor()) {
                return false;
            }
            if (!event.tab() && event.direction().method_48237() == class_8027.field_41823) {
                if (this.method_25370()) {
                    this.setFocused(null);
                    return false;
                }
                int lastIndex = this.parent.lastIndex;
                if (lastIndex >= this.children.size()) {
                    lastIndex = this.children.size() - 1;
                }
                if (!this.children.get(lastIndex).onNavigation(event)) {
                    return false;
                }
                this.setFocused(this.children.get(lastIndex));
                return true;
            }
            boolean result = NavigationUtils.tryNavigate((NavigationEvent)event, this.children, (SpruceWidget)this.focused, this::setFocused, (boolean)true);
            if (result) {
                this.method_25365(true);
                if (event.direction().method_48237() == class_8027.field_41822 && this.getFocused() != null) {
                    this.parent.lastIndex = this.children.indexOf(this.getFocused());
                }
            }
            return result;
        }
    }

    public static final class LightSourceEntry
    extends LightSourceListEntry {
        private final DynamicLightHandlerHolder<?> option;

        private LightSourceEntry(LightSourceListWidget parent, DynamicLightHandlerHolder<?> option) {
            super(parent);
            this.option = option;
        }

        public static LightSourceEntry create(LightSourceListWidget parent, DynamicLightHandlerHolder<?> option) {
            LightSourceEntry entry = new LightSourceEntry(parent, option);
            LightSourceSettingEntry setting = option.lambdynlights$getSetting();
            SpruceLabelWidget label = new SpruceLabelWidget(Position.of((SprucePositioned)entry, (int)(entry.getWidth() / 2 - 145), (int)7), option.lambdynlights$getName(), 175);
            if (class_310.method_1551().field_1690.field_1827) {
                class_2960 id = class_7923.field_41177.method_10221((Object)((class_1299)option));
                label.setTooltip((class_2561)class_2561.method_43470((String)id.toString()).method_27692(class_124.field_1080));
            }
            entry.children.add(label);
            entry.children.add(setting.getOption().createWidget(Position.of((SprucePositioned)entry, (int)(entry.getWidth() / 2 + 70), (int)2), 32));
            return entry;
        }
    }
}

